import {Player, system, world, ItemStack,Vector, ItemLockMode, EntityVariantComponent} from "@minecraft/server"; import { ActionFormData, ModalFormData } from "@minecraft/server-ui"; 

import * as classes from "./Classes";
import {Human, Teacher, Student, addPersonalToClass} from "./Humans";
import {School, createSchool, showSchool} from "./School";

import { CommandJ } from "./Command";
import { initialId, schoolMenus, saveHumanData, registration, saveSchoolData, loadSchools } from "./backgroundFunctions";
import { editSchools } from "../manageMenus/classMenus";

world.beforeEvents.chatSend.subscribe((event)=>{
    if(event.message =="-sync"){ event.cancel=true; system.run(()=>{
        if(event.sender.hasTag('registered')==false || !event.sender.getDynamicProperty("jo:humanData")){
            let time = Date();
            let player = event.sender;
            let human = new Human(player.name,player.name, time, initialId());
            human.registerHuman();
            player.setDynamicProperty("jo:humanId", human.identifier);
            player.setDynamicProperty("jo:humanData", human.getSaveString());
            player.setDynamicProperty("jo:humanType", 0);
            console.warn(human.getSaveString());
            let l = world.getDynamicProperty("jo:humanIds"); l++;
            world.setDynamicProperty("jo:humanIds", l)
            /**
             * @type {EntityInventoryComponent}
             */
            let inv = player.getComponent("minecraft:inventory");
            let item = new ItemStack("jo:menu", 1);
            item.nameTag = "§r§fMenu";
            item.keepOnDeath = true;
            item.lockMode = ItemLockMode.inventory;
            item.setLore(["§eInteract to see options!§r"]);
            inv.container.setItem(8, item);
            player.addTag("registered");
            world.sendMessage("A new Human has entered this world: "+player.name);
        }else if(event.sender.hasTag('registered')==true){
            let human;
            console.warn(event.sender.getDynamicProperty("jo:humanType").toString())
            switch(event.sender.getDynamicProperty("jo:humanType")){
                case 0: let data0 = JSON.parse(event.sender.getDynamicProperty("jo:humanData")); human = new Human(data0.name, data0.familyName, data0.birthdate, event.sender.getDynamicProperty("jo:humanId")); human.loadSaveString(event.sender.getDynamicProperty("jo:humanData")); break;
                case 1: let data1 = JSON.parse(event.sender.getDynamicProperty("jo:teacherData")); human = new Teacher(data1.name, data1.familyName, data1.birthdate, event.sender.getDynamicProperty("jo:humanId")); human.loadDataFromTeacher(event.sender.getDynamicProperty("jo:teacherData")); break;
                case 2: let data2 = JSON.parse(event.sender.getDynamicProperty("jo:studentData")); human = new Student(data2.name, data2.familyName, data2.birthdate, event.sender.getDynamicProperty("jo:humanId")); human.loadDataFromStudent(event.sender.getDynamicProperty("jo:studentData")); break;
                default: break;
            };
            human.registerHuman();
            world.sendMessage("Welcome Back, "+human.name+" "+human.familyName+"!");
            system.runTimeout(()=>{School.updateOld();}, 20);
        }
    })}
});
world.beforeEvents.itemUse.subscribe((event)=>{
    if(event.itemStack.getLore()[0]=="§eInteract to see options!§r"){
        event.cancel = true; system.run(()=>{schoolMenus(event.source)});
    }
});
system.afterEvents.scriptEventReceive.subscribe((event)=>{
    if(event.message == "run"){
        for(let i = 0; i<CommandJ.storage.length; i++){
            if(CommandJ.storage[i].id==event.id){
                /* create an entry for every argument*/
                let args = [];
                let f = new ModalFormData();
                f.title("Args"); 
                for(let a = 0; a < CommandJ.storage[i].args.length; a++){
                    f.textField(CommandJ.storage[i].args[a], "Enter here!");
                };
                /* get argument values and run command*/
                system.runTimeout(()=>{
                    if(CommandJ.storage[i].args.length <1){
                        CommandJ.storage[i].run(event.sourceEntity, "", event, args);
                        return;
                    }else{ 
                        f.show(event.sourceEntity).then((r)=>{
                            if(r.canceled){return;} 
                            args = r.formValues;
                            CommandJ.storage[i].run(event.sourceEntity, "", event, args)
                            return;
                        })}
                }, 20)
            }
        };
    }
});
 
world.afterEvents.worldInitialize.subscribe((data)=>{
    let l;
    if(!world.getDynamicProperty("jo:humanIds") || typeof world.getDynamicProperty("jo:humanIds") != Number){ l=0; console.warn("l is: "+l); world.setDynamicProperty("jo:humanIds", l);
    }else { l=world.getDynamicProperty("jo:humanIds"); console.warn("l is: "+l); world.setDynamicProperty("jo:humanIds", l); };
    system.runTimeout(registration, 1); system.runTimeout(saveHumanData, 1); system.runTimeout(saveSchoolData, 2); system.runTimeout(loadSchools, 2);
    /* enter custom Commands for later use*/
    let changePropertyC = new CommandJ("jo:chPr", "change player properties", (player, dataType, data, additional)=>{if(typeof player.getProperty(additional[0]) == "number"){player.setProperty(additional[0], parseInt(additional[1]));}else { player.setProperty(additional[0], (additional[1].toLowercase()==="true"))}world.sendMessage(player.getProperty(additional[0])+" for "+typeof player.getProperty(additional[0]))}, ["property to change:", "value to set to:"]);
    changePropertyC.registerCommand();

    let teacherC = new CommandJ("jo:teacherC", "Turns Human into Teacher", (player, dataType, data, additional)=>{ let hum = Human.lookForHuman(player.getDynamicProperty("jo:humanId")); if(hum.type==0){ hum = hum.becomeTeacher(); } }, []); 
    teacherC.registerCommand();
    let hummanC = new CommandJ("jo:hummanC", "Turns Student or Teacher into Humman", (player, dataType, data, additional)=>{ let hum = Human.lookForHuman(player.getDynamicProperty("jo:humanId")); if(hum.type == 1 || hum.type == 2){ hum = hum.becomeHuman() } }, []); 
    hummanC.registerCommand();
    let studentC = new CommandJ("jo:studentC", "Turns Human into Student", (player, dataType, data, additional)=>{ let hum = Human.lookForHuman(player.getDynamicProperty("jo:humanId")); if(hum.type == 0){ hum= hum.becomeStudent(); } }, []); 
    studentC.registerCommand();
    let schoolDataMenuTableC = new CommandJ("jo:schoolTable", "Shows a Menu with all School's data", (player, dataType, data, additional)=>{showSchool(player); return;}, []);
    schoolDataMenuTableC.registerCommand();
    let schoolC = new CommandJ("jo:schoolCreator", "Allows a Player to create a new School", (player, dataType, data, additional)=>{ createSchool(player); }, []);
    schoolC.registerCommand();
    let personalC = new CommandJ("jo:addPersonal", "Allows a Player to set a Human as a School Personal", (player, dataType, data, additional)=>{ addPersonalToClass(player, School.lookForSchool(additional[0]))}, ["School"]);
    personalC.registerCommand();
    let editC = new CommandJ("jo:editC", "Allows player to edit All School data", (player, dataType, data, additional)=>{editSchools(player);}, []);
    editC.registerCommand();
});

// system.runInterval(()=>{
//     world.getPlayers({tags:["cam_changer"]}).forEach((player)=>{
//         let pos = player.location; let dis = player.getViewDirection();pos.y = (pos.y+1.8)*player.getComponent("minecraft:scale").value;
//         let pos2 = Vector.add(pos, dis);// pos2 = Vector.multiply(pos2, 0.5)
//         player.camera.setCamera("minecraft:free", {easeOptions: {easeTime: 0.3, easeType:"Linear"}, rotation:player.getRotation(), location:pos2})
//     })
// }, 5)